
*** we want to merge w/ CDS data 
** from here
use "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Control Banks\Control_Data\Stack\fullvars_stack.dta", clear
gen imp_minus_market = impvol - market_imp 
gen vol_minus_market = vol_thirty - market_vol 
gen imp_div_market = impvol/market_imp
gen vol_div_market=vol_thirty/market_vol 
gen crisis = . 
replace crisis = 0 if year >= 2002 & year <= 2007 
replace crisis = 1 if year >= 2010
**replace crisis = 2 if year == 2015  
gen big6 = 0 
replace big6 = 1 if name == "baml" | name == "ms" | name == "jpm" | name == "gs" | name == "wf" | name == "citi"

by crisis name, sort: egen beta_crisis = mean(beta)
by crisis name, sort: egen cds_crisis = mean(cds)
by crisis name, sort: egen vol_crisis = mean(vol) 
by crisis name, sort: egen impvol_crisis = mean(impvol)
by crisis name, sort: egen ptb_crisis = mean(ptb)
by crisis name, sort: egen imp_minus_market_crisis = mean(imp_minus_market)
by crisis name, sort: egen vol_minus_market_crisis = mean(vol_minus_market)
by crisis name, sort: egen vol_div_market_crisis = mean(vol_div_market)
by crisis name, sort: egen imp_div_market_crisis = mean(imp_div_market)
by crisis name, sort: egen markcap_crisis = mean(markcap)
drop output_indicator
by crisis name, sort: gen output_indicator = _n 
*replace output_indicator = 0 if output_indicator != 1
 
*** for just big6 
*** top 50 need quintiles 

keep if big6 == 1
br name crisis markcap_crisis vol_crisis vol_div_market_crisis vol_minus_market_crisis impvol_crisis imp_div_market_crisis imp_minus_market_crisis beta_crisis cds_crisis ptb_crisis if output_indicator == 1 & crisis != .
*** gets us same numbers as in paper 
/*
format date %td

br date
capture drop year
capture drop month 
gen year = year(date)
gen month = month(date) 

by year month name, sort: egen beta_avg = mean(beta)
by year month name, sort: egen cds_avg = mean(cds)
by year month name, sort: egen vol_avg = mean(vol) 
by year month name, sort: egen impvol_avg = mean(impvol)
by year month name, sort: egen ptb_avg = mean(ptb)
by year month name, sort: egen imp_minus_market_avg = mean(imp_minus_market)
by year month name, sort: egen vol_minus_market_avg = mean(vol_minus_market)
by year month name, sort: egen vol_div_market_avg = mean(vol_div_market)
by year month name, sort: egen imp_div_market_avg = mean(imp_div_market)
by year month name, sort: egen markcap_avg = mean(markcap)

capture drop output_indicator 
by year month name, sort: gen output_indicator = _n 
keep if output_indicator == 1

save "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data October 2016\Data\full_data_monthly_10202016.dta", replace*/

capture drop _merge 

save "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data October 2016\Data\full_data_10202016.dta", replace

capture drop output_indicator 

*** one observation per month per year 
use "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Control Banks\Control_Data\full_vars_mve_riskassets_09052016.dta", clear

drop _merge 

format date %td

br date
capture drop year
capture drop month 
gen year = year(date)
gen month = month(date) 

keep if big6 == 1 

*** merge with the full vars data
merge 1:1 date name using "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data October 2016\Data\full_data_10202016.dta"
keep if _merge == 3 
*** the remaining are 2016 dates

*** now our focus is on MVE/assets and CDS spread 
capture drop output_indicator
by year name, sort: egen cds_annual = mean(cds)
by year name, sort: egen mve_annual = mean(mve_div_assets)
by year name, sort: gen output_indicator = _n 
br year name cds_annual mve_annual if output_indicator == 1 & year >= 2004 

*** unfortunately we don't have CDS data prior to 2004. 
*** we want scatters by bank 
keep if output_indicator == 1 & year>= 2004 

label var cds_annual "CDS"
label var mve_annual "MVE/A"

cd "C:\Users\nsarin\Dropbox\Z__Natamir\Natasha_Research\Banks\Data October 2016\Tables"

graph twoway (scatter cds_annual year, yaxis(1) cmissing(no) ytitle("CDS Spread")) || (scatter mve_annual year, yaxis(2) cmissing(no) ytitle("MVE/assets ratio", axis(2))) if (name == "baml"), xtitle("") title("Bank of America") xlabel(,labsize(small)) 

graph export baml_cds_mve.png, replace 

graph twoway (scatter cds_annual year, yaxis(1) cmissing(no) ytitle("CDS Spread")) || (scatter mve_annual year, yaxis(2) cmissing(no) ytitle("MVE/assets ratio", axis(2))) if (name == "citi"), xtitle("") title("Citigroup") xlabel(,labsize(small)) 

graph export citi_cds_mve.png, replace 

graph twoway (scatter cds_annual year, yaxis(1) cmissing(no) ytitle("CDS Spread")) || (scatter mve_annual year, yaxis(2) cmissing(no) ytitle("MVE/assets ratio", axis(2))) if (name == "gs"), xtitle("") title("Goldman") xlabel(,labsize(small)) 

graph export gs_cds_mve.png, replace 

graph twoway (scatter cds_annual year, yaxis(1) cmissing(no) ytitle("CDS Spread")) || (scatter mve_annual year, yaxis(2) cmissing(no) ytitle("MVE/assets ratio", axis(2))) if (name == "wf"), xtitle("") title("Wells Fargo") xlabel(,labsize(small)) 

graph export wf_cds_mve.png, replace 

graph twoway (scatter cds_annual year, yaxis(1) cmissing(no) ytitle("CDS Spread")) || (scatter mve_annual year, yaxis(2) cmissing(no) ytitle("MVE/assets ratio", axis(2))) if (name == "ms"), xtitle("") title("Morgan Stanley") xlabel(,labsize(small)) 

graph export ms_cds_mve.png, replace 

graph twoway (scatter cds_annual year, yaxis(1) cmissing(no) ytitle("CDS Spread")) || (scatter mve_annual year, yaxis(2) cmissing(no) ytitle("MVE/assets ratio", axis(2))) if (name == "jpm"), xtitle("") title("JP Morgan") xlabel(,labsize(small)) 

graph export jpm_cds_mve.png, replace 

